(function() {
    const i18n = dks_state.i18n;
    const host = document.getElementById('dks[server]');
    const apikey = document.getElementById('dks[apikey]');
    const jsonSettings = document.getElementById('dks-advanced[json]');

    const setStatus = (message, type) => {
        var status = document.getElementById('dks-status-area');
        if (status) {
            status.innerText = message;
            status.className = 'alert-message dks-' + type
        }
    };

    const checkJSON = () => {
        try {
            JSON.parse(jsonSettings.value);
            jsonSettings.classList.remove('dks-alert');
            jsonSettings.classList.add('dks-success');
        } catch (e) {
            jsonSettings.classList.add('dks-alert');
            jsonSettings.classList.remove('dks-success');
        }
    }

    window.addEventListener('load', async () => {
        if (jsonSettings) {
            jsonSettings.addEventListener('input', checkJSON)
            checkJSON();
        }
        try {
            const response = await fetch(dks_state.plugin_directory + "?p=/api/version");
            console.log(dks_state.plugin_directory + "?p=/api/version");
            if (response.status == 401) {
                host.classList.add('dks-success')
                apikey.classList.add('dks-alert');
                setStatus(i18n.dksState401, "alert");
            } else {
                const version = await response.json();
                state = "Connection to DKS was successful: DPF Version: " + version['DPF version'] + ", Server Version: " + version['Server version'];
                host.classList.add('dks-success')
                apikey.classList.add('dks-success');
                setStatus(i18n.dksStateOK, "success");
            }
        } catch (e) {
            setStatus(i18n.dksStateFail, "alert");
            if (host) {
                host.classList.add('dks-alert')
            }
        }
    });
})();

