(function () {
    let pluginInitialized = false;
    const PluginDudenToggleButton = (props) => {
        if (pluginInitialized)
            return;

        pluginInitialized = true;

        var dkceInitialized = false;

        let settings = {
            ...DKCE_SETTINGS,
            overlayMode: true,
            setupWatcher: false,
            activated: (localStorage.getItem('gutenberg.duden.activated') === 'true'),
            configFile: null
        };

        const dkceIcon = document.createElement('img');
        dkceIcon.src = settings.path + 'assets/icon_32.png';
        dkceIcon.style.borderRadius = '2px';

        const dkceButton = document.createElement('button');
        dkceButton.className = 'components-button has-icon dkce-toggle-button';
        dkceButton.type = "button";
        dkceButton.appendChild(dkceIcon);

        const setButtonStyle = (isHovered, isActive) => {
            const css = dkceButton.style;

            css.borderRadius = '2px';
            css.backgroundColor = 'inherit';
            css.filter = 'grayscale(100%)'
            css.webkitFilter = 'grayscale(100%)'
            css.opacity = 0.5;

            if (isHovered) {
                css.backgroundColor = '#017cba';
            }

            if (isHovered || isActive) {
                css.opacity = 1.0;
                css.filter = ''
                css.webkitFilter = ''
            }
        };

        dkceButton.addEventListener('mouseover', () => {
            setButtonStyle(true, settings.activated);
        });

        dkceButton.addEventListener('mouseleave', () => {
            setButtonStyle(false, settings.activated);
        });

        dkceButton.addEventListener('click', () => {
            if (dkceInitialized) {
                settings.activated = !settings.activated;
                const message = {
                    subject: 'activate',
                    activate: settings.activated
                }

                localStorage.setItem('gutenberg.duden.activated', settings.activated);
                window.postMessage(message, window);
            }

            setButtonStyle(false, settings.activated);
        });

        const insertToggleButton = () => {
            const wpHeaderToolbar = document.querySelector('.edit-post-header__settings') || document.querySelector('.edit-post-header__toolbar') || document.querySelector('.editor-header__settings');
            if (!wpHeaderToolbar) {
                console.warn("DKCE could not be initialized because could not find Gutenberg Publish Button. Try again in 1 second.");
                window.setTimeout(insertToggleButton, 1000);
                return;
            }
            wpHeaderToolbar.prepend(dkceButton);
            setButtonStyle(false, settings.activated);
        };

        ignoreElement = (element) => {
            return (!element.isContentEditable) || (element.hasAttribute('dkceSpellcheckerId'));
        };

        createSpellchecker = (element) => {
            DKCE.init(element, settings, () => {
                dkceInitialized = true;
            });
        };

        checkForNewBlocks = () => {
            const root = document.querySelector("iframe[name='editor-canvas']")?.contentWindow.document.body || document;
            const elementsToCheck = root.querySelectorAll(".rich-text,.block-library-rich-text__tinymce");
            for (element of elementsToCheck) {
                if (ignoreElement(element)) continue;
                createSpellchecker(element);
            }
            setTimeout(checkForNewBlocks, 1000);
        }

        window._wpLoadBlockEditor.then(() => {
            setTimeout(checkForNewBlocks, 100);
        });

        insertToggleButton();
    };

    window.addEventListener('load',() => {
        wp.plugins.registerPlugin('plugin-document-setting-panel-duden', {
               render: PluginDudenToggleButton
        });
    });
})();