(function () {
    tinymce.PluginManager.add('dks', function (editor, url) {
        console.log(url);
        console.log(DKCE_SETTINGS);
        var dkceEnabled = false;
        var dkceInitialized = false;
        
        // Add Command when Button Clicked
        editor.addCommand('toggleDKS', function () {
            dkceEnabled = !dkceEnabled;
            if ( !dkceInitialized ) {
                DKCE.init(editor.contentDocument.body, DKCE_SETTINGS);
                dkceInitialized = true;
            }
            DKCE.activate(dkceEnabled);
            editor.fire('dksToggled', {state: dkceEnabled});
        });
        // Add Button to Visual Editor Toolbar
        editor.addButton('dks', {
            title: 'DKS',
            cmd: 'toggleDKS',
            image: `${url}/assets/icon_48.png`,
            onpostrender: function() {
                var self = this;
                editor.on('dksToggled', function(e) {
                    self.active(e.state);
                });
            }
        });

        editor.addShortcut('ctrl+shift+a', 'Activate DKS', 'toggleDKS');

        editor.on('init',function() {
            DKCE.activate = (activate) => {
                window.postMessage({ 'subject': 'activate', 'activate': activate }, window.location.href)
            };
        
            DKCE.toast = (message) => {
                window.postMessage({ 'subject': 'toast', 'message': message, 'noerror': true }, window.location.href)
            }
            //DKCE.init(editor.contentDocument.body, DKCE_SETTINGS);
        })


    });
})();