<?php
require_once __DIR__ . '/../../../config/config.php';
require_once BASEDIR . '/server/secure.php';
require_once BASEDIR . '/server/services/wfl/WflGetObjectsService.class.php';
require_once BASEDIR . '/server/protocols/soap/WflClient.php';
require_once BASEDIR . '/server/utils/TransferClient.class.php';

try {
    $ticket = $_COOKIE['tickets']['Content+Station'] ?? $_COOKIE['tickets']['Content Station'] ?? null;
    if (!$ticket) {
        http_response_code(401);
        die('ERROR: Authentication ticket not found.');
    }	

   $objectId = $_POST['articleId'] ?? null;
   if (!$objectId) {
        http_response_code(400);
        die('ERROR: Invalid or missing article ID.');
    }

    $request = new WflGetObjectsRequest();
    $request->Ticket = $ticket;
    $request->IDs = array($objectId);
    $request->Lock = false;
    $request->Rendition = 'native';

    $options = array('transfer' => 'HTTP', 'protocol' => 'SOAP');
    $soapClient = new WW_SOAP_WflClient($options);
    $response = $soapClient->GetObjects($request);

    if (!isset($response->Objects[0]->Files)) {
        http_response_code(404);
        die('ERROR: No files found for the specified object.');
    }

    $nativeFile = null;
    foreach ($response->Objects[0]->Files as $file) {
        if (isset($file->Rendition) && $file->Rendition === 'native') {
            $nativeFile = $file;
            break;
        }
    }

    if ($nativeFile) {
        $transferClient = new WW_Utils_TransferClient($ticket);
        $result = $transferClient->downloadFile($nativeFile);

        if ($result && isset($nativeFile->Content)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . basename(uniqid() . ".wcml") . '"');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . strlen($nativeFile->Content));

            echo $nativeFile->Content;
            exit;
        } else {
            http_response_code(500);
            die('ERROR: Failed to download the file from the transfer server.');
        }
    } else {
        http_response_code(404);
        die('ERROR: Native file rendition not found for the article.');
    }
} catch (Exception $e) {
    http_response_code(500);
    die("An unexpected error occurred");
}
