<?php
require_once __DIR__ . '/../../../config/config.php';
require_once BASEDIR . '/server/secure.php';
require_once BASEDIR . '/server/services/wfl/WflGetObjectsService.class.php';
require_once BASEDIR . '/server/protocols/soap/WflClient.php';
require_once BASEDIR . '/server/utils/TransferClient.class.php';

try {
    $ticket = $_COOKIE['tickets']['Content+Station'] ?? $_COOKIE['tickets']['Content Station'] ?? null;
    if (!$ticket) {
        http_response_code(401);
        die('ERROR: Authentication ticket not found.');
    }	

   $objectId = $_POST['articleId'] ?? null;
   if (!$objectId) {
        http_response_code(400);
        die('ERROR: Invalid or missing article ID.');
    }

    $request = new WflGetObjectsRequest();
    $request->Ticket = $ticket;
    $request->IDs = array($objectId);
    $request->Lock = false;
    $request->Rendition = 'native';

    $options = array('transfer' => 'HTTP', 'protocol' => 'SOAP');
    $soapClient = new WW_SOAP_WflClient($options);
    $response = $soapClient->GetObjects($request);

    if (!isset($response->Objects[0]->MetaData->BasicMetaData->Publication)) {
        http_response_code(404);
        die('ERROR: No metadata found for the specified object.');
    }

    echo json_encode($response->Objects[0]->MetaData->BasicMetaData->Publication);
} catch (Exception $e) {
    http_response_code(500);
    die("An unexpected error occurred");
}
