# Duden Korrektur Woodwing Plugin

### Installation Instructions

1. Unpack the contents of the archive into the Woodwing Contentstation SDK folder under ./sdk/duden,
e.g. to /var/www/html/StudioServer/contentstation/sdk/duden/

2. In the dks-api-proxy.php file, set the $DKS_URL to the DKS used

3. If necessary, adjust the pluginBasePath (at the end of the file) in dkce.js. If this is not done, the
default path relative to the server host is "/StudioServer/contentstation/sdk/duden"
(i.e. https://mein.server.com/StudioServer/contentstation/sdk/duden for hosting at https://mein.server.com)

4. Activate the plugin in the config.js of Contentstation by adding 'sdk/duden/dkce.js' in the usual way to the
 plugins for contentStation or digitalEditor.

5. You can also (optionally) define whether the Duden plugin is automatically activated when an article is opened.

To do this, also in config.js, add the following properties to the "window.csConfig" object:

You can also define correction profiles that should be available for the user to select. The selection can be configured individually for both the digital and print editors. Please ensure that the correction profiles exist on the DKS. Use the `availablePropertySets` property in the configuration to provide a list of correction profiles. The first profile in the list is always the default profile. If the setting is omitted completly the 'base' profile is used by default.

```js
    dudenSettings: {
        digitalEditor: {
            autoActivate: true,
            availablePropertySets: ["Profile 1", "Profile 2"],
            activateForLanguages: ['deDE', 'fr']
        },
        printEditor: {
            autoActivate: false,
            availablePropertySets: ["Profile 3", "Profile 4"],
            activateForLanguages: ['*']
        }
    },
```

The `activateForLanguages` property is optional (`['deDE']` is default value). It allows you to define a list of language codes for which the plugin should be activated. For example, providing `['deDE']` will activate the plugin only when the Content Station user account's language is set to `German`. If you omit this property or provide a wildcard (`['*']`), the plugin will always be loaded regardless of the user's language setting.

Under `digitalEditor` and `printEditor` you can also add all existing Duden Settings (you will find a full list of all options below in this document under Settings.

### Settings

There are a lot of different settings you can provide on initialisation. Here is a full list of all settings available.

If you want to use different settings for the digital or print editor you can add specific settings to the `dudenSettings` property in you Content Station configuration file, for example:

```js
    dudenSettings: {
        digitalEditor: {
            /* ... */
            dictionaries: ['My Digital Dictionary']

        },
        printEditor: {
            /* ... */
            dictionaries: ['Other Dictionary'],
            openContextMenuOn: 'leftClick'
        }
    },
```

You can also provide configuration by creating a new file `duden-config.json` in the plugin directory and put the JSON Settings in there, for example:

```js
{
    propertySets: ["base"],
    ...
}
```

Below is a comprehensive list of all Duden Plugin settings:

```js
{
    // Enables AI functionality (requires AI Support in DKS)
    // Currently this only works with the TinyMCE 5+ Plugin (Support may be added at a later point)
    // Default is false
    ai: true,

    // If apiEndpoint is ommited it will default to the PHP Proxy Script,
    // so make sure that you have updated the script with your credentials
    // If you set an API Endpoint directly, please make sure that the DKS
    // is available from your network or provide separate credentials
    //
    // Note: By default the Woodwing plugin uses a proxy script, so if you configured
    // the dks-api-proxy.php file like stated above, you don't need to add any credential
    // in the config. If you don't want to use the dks proxy script, you can set
    // the DKS Host and credentials 
    //
    apiEndpoint: 'http://127.0.0.1:8080/api',

    // If the API is not publicly available please add the
    // credentials to an API user
    // You can either use a username/password combination or an apiKey
    apiCredentials: {
        username: "duden",
        password: "duden" /*,
        apiKey: "??????????" */
    },

    // Which property sets should the DKS use
    propertySets: ["base"],

    // Which dictionaries sets should the DKS use
    dictionaries: [],

    // Can be used to activate debug output to browser console.
    debug: false,

    // If a user manually adds hyphenation, DKCE will auto detect it and
    // replaces the '-' char with a soft hyphen
    detectManualHyphenation: true,

    // Which language should the DKCE UI use
    // Defaults to the browser language of the user
    language: "de",

    // Which fallback Language should the DKCE Plugin use, if the
    // main language cannot be found. This is especially important when
    // you ommit the language setting, and the language is detected
    // automatically by the users browser settings.
    fallbackLanguage: "de",

    // Should the plugin be activated. If set to false, you can activate
    // it at a later point
    activated: true,

    // Optional: Defines when the Spellchecking Pop Up appears,
    // following options are possible:
    //      'mouseOver'  - Automatically opens pop up when you hover an error highlight (Default)
    //      'leftClick'  - Opens pop up when you left click on an error highlight
    //      'rightClick' - Opens pop up when you right click on an error highlight
    openContextMenuOn: 'mouseOver',

    // Can be used to disable the Duden-Status-Panel at the top of the screen
    // (which indicates network communication)
    // Defaults to: false
    hideStatusPanel: false,

    // You can set the options how the DKS should behave, but keep in mind
    // that the DKS Server may overwrite these settings
    // Please check the DKS Readme if you want to learn more about them.
    hyphenation: true,
    hyphenationStandard: "combined",
    hyphenationInStem: true,
    hyphenationUnaest: false,

    // When set it will ignore spellchecks for all child elements who has
    // the given attribute in the HTML set (can be string or array of strings)
    ignoreAttributes: [],

    // When set it will separate spellchecks for all child elements who has
    // the given attribute in the HTML set (can be string or array of
    // strings). This can be useful for footnotes in HTML code, for example.
    layerAttributes: [],

    // Use single word mode for layers defined in layer Attributes (except when it detects
    // end of sentence characters. Default is true.)
    useSingleWordModeOnLayers: true,

    // Every HTML element that contains at least one of the attributes defined
    // here will be checked by the spell checker in Single Word Mode
    // (useful, e.g., for headings or lists)
    singleWordModeAttributes: ['duden-use-single-word-mode'],

    // Every HTML element that contains at least one of the classes defined
    // here will be checked by the spell checker in Single Word Mode
    // (useful, e.g., for headings or lists)
    singleWordModeClasses: ['duden-use-single-word-mode'],

    // When set it will ignore spellchecks for all child elements who has
    // the given css class in the HTML set (can be string or array of strings)
    ignoreClasses: [],

    // Array of objects that define specific error codes to ignore based on CSS selectors.
    // Each object contains 'code' (error code number) and 'selector' (CSS selector string).
    // The logic is applied recursively for all child elements of selector nodes.
    // Example: [{ code: 111, selector: '.no-lowercase-check' }, { code: 166, selector: '.no-sentence-end-check' }]
    // Note: In Woodwing, error codes are automatically populated from InDesign paragraph style properties
    ignoreErrorCodes: [],

    // Every single character of this string will be ignored during the
    // correction check. This can be useful, for example, if the editor
    // inserts characters for marking that are to be ignored by the spell checker.
    ignoreCharacters: "",

    // When set it will ignore spellchecks for paragraphs that have a
    // language attribute attached that are not defined here. If ommited all languages will be checked.
    checkLanguages: [],

    correctionProposals: true,
    singleWordMode: false,
    styleForeign: false,
    styleOld: false,
    styleRegional: false,
    styleColloquial: false,
    styleFiller: false,
    markupMode: "text",
    messageLanguage: "de-DE",
    textLanguage: "de-DE",
    messageLevel: 3,
    spellcheckingLevel: 1,
    orthographyStandard: "duden",

    // Sets the dictonary where proposals will be submitted to. (Default is 'Proposals')
    proposalDictionary: "Proposals",

    // Use markup mode instead of overlay mode (which is the default)
    overlayMode: false,

    // If set to true (and instance is in MarkUp Mode) all markup code is
    // removed from selections (and readded when selection is removed)
    removeMarkupForSelection: false,

    // colors can be used to define the appearance of the highlights. Please keep in mind
    // that in markup mode, the colors may be overwritten by included css Files
    colors: {
        spellingError: '#faa6ae',
        gramarError: '#abe89e',
        rejectedWord: '#abe89e',
        styleError: '#ffd7a8',
        glossaryInfo: '#ffff00'
    },

    // If set to true, the duden will observe the HTML Elements and inject the Spellchecker automatically
    // on dynamically created or changed HTML nodes
    setUpWatcher: false,

    // Array of CSS Files to use for DKCE. Please keep in mind that most
    // of the css classes only make sense in markup mode
    cssFiles: ['assets/css/dkce.css'],

    // Path to the dkce javascript source files. Is important so the
    // plugin finds the assets like images and localization files.
    path: "dkce",

    // If a canvas exceeds this size (in pixels) in overlay mode,
    // it is split into several individual ones
    maxCanvasWidth: 512,
    maxCanvasHeight: 512,

    // Makes the overlay canvas elements visible (for debugging purposes)
    debugCanvas: false,

    // The zIndex where the highlights should be rendered. In general this should be higher than the editor element
    // but lower than pop ups / toolbars etc, that are laying in front of the editor.
    zIndex: 20
}
```

### Map Publications to specific settings

You can optionally define specific settings for individual publications. This allows you to override global or default settings by identifying the target publication by its `name` or `id`.

```js
  dudenSettings: {
    digitalEditor: {
      autoActivate: false,
      availablePropertySets: ["DKS-Profil-Gemeinden", "DKS-Profil-Redaktion"],
      textLanguage: "de-DE",
    },
    printEditor: {
      autoActivate: false,
      availablePropertySets: ["DKS-Profil-Gemeinden", "DKS-Profil-Redaktion"]
    },
    publication: [{
      id: "1",
      settings: {
        textLanguage: "fr"
        /* ... */
      }
    }, {
      name: "Italienische Publikation",
      settings: {
        textLanguage: "it"
        /* ... */
    }}]
  },
```

In the first object within the `publication` array, `textLanguage` is set to `fr` for the publication with `id`: "1". (Note: Defining the `id` as a string is correct here, as the ContentStation API returns it as a string).

Similarly, in the second object, `textLanguage` is set to `it` for the publication with name: `Italienische Publikation`.

You can add as many settings as needed (see the **Settings** section above for a complete list).

### Understanding settings precedence

It is important to understand the order in which different settings are applied. The prioritization is as follows:

1. **Contentstatation Configuration (Base Settings)**
Initially, the system uses the settings configured in the ContenStation Configuration file, depending on whether you are in the digital or print editor of woodwing (e.g, settings from ´dudenSettings.digitalEditor´ or ´dudenSettings.printEditor´).

2. **Publication specific overrides**
If entries exist under ´dudenSettings.publication´ that match the current article (either by ID or name), any settings defined there will override the corresponding base settings from step 1.

3. **DKS Server**
If the ´Enforce these settings´ is checked on the ´Correction Profiles´ on the DKS Server this will override all other settings from Step 1 and 2.

### Communication with the Plugin

You can send messages to the Plugin, for example to activate it or to update the user settings. This is done through the Browsers Message System.

#### Activate the plugin

```js
window.postMessage({
    'subject': 'activate',
    'activate': true
}, window.location.href);
```
#### Deactivate the plugin

```js
window.postMessage({
    'subject': 'activate',
    'activate': true
}, window.location.href);
```

#### Update the settings

```js
window.postMessage({
    'subject': 'update_settings',
    'settings': {
        /* Whatever settings you want to update */
    }
}, window.location.href);
```

#### Listen to content updates

Whenever the content of the element has updated the DKCE is attached to, a *content_changed* event is sent back via the messaging api. You can listen to it like this:

```js
window.addEventListener("message", (event) => {
    if (event.data === 'content_changed') {
        /* Do something */
    }
};
```

### Special Attributes and Classes

If a DOM Element (or a parent Element) in which the spellchecker is injected contains either the class or the attribute *duden-use-single-word-mode*, the single word mode is enforced for the spellchecking. This might be useful for Elements that expect a single word or a headline as example.

```html
    <textarea contenteditable="true" duden-use-single-word-mode>
    </textarea>

    <textarea contenteditable="true" class="duden-use-single-word-mode">
    </textarea>
```

## License

(C) Copyright 2025 by EPC Consulting und Software GmbH.
