# Duden Korrektur TinyMCE Plugin

This is a TinyMCE Plugin for using DKS (Duden Korrektur Server) with TinyMCE. It is compatible with TinyMCE 3-7.

### Requirements

- A functioning TinyMCE implementation.
- Access to the server to edit configuration and uploading files.
- Server with PHP, if you want to use the PHP Proxy Sript (which is used by Default)
- Server with PERL, if you want to use the PERL Proxy Script

### Installation Instructions

1. Unzip/Copy the "duden" directory into the "plugins" directory of your TinyMCE Installation. The path should be "plugins/duden".

2. If you want to connect to the DKS-Server through a Proxy-Script open the associated file. We have an implemenation in [PERL](https://www.perl.org/) and [PHP](https://www.php.net/). They are located in the **'perl'**/**'php'** subdirectory of the Duden TinyMCE Plugin. Insert your credentials into these files. Do **_not_** provide any credentials if the DKS is not protected by username and password. You can skip this step, if you want to use an API-User to make requests to the DKS. By default, the Duden Plugin tries to use the PHP Script.

3. Verify that the DKS is reachable. If the api is not secured and publicly available you can try by using the command "wget $DCS_URL/version"

4. Edit your TinyMCE configuration. Add "duden" to the list of plugins.

5. Add "duden_check" as a button some where on your toolbar

6. To enable the advanced language selection mode, where the language can be set for individual paragraphs, add "duden_lang" to the toolbar setting. (This is only supported in TinyMCE 3 at the moment).

### Initialization Examples

**TinyMCE 3:**
```javascript
tinymce.init({
    selector: "textarea",
    plugins: "duden",
    paste_as_text: true,
    theme : "advanced",
    theme_advanced_buttons1: "duden_menu,duden_check,duden_lang"
});

If you don't want the Duden-Icons to show up you can omit it in the 'theme_advanced_buttons1' property.

```

**TinyMCE 4 / TinyMCE 5 / TinyMCE 6 / TinyMCE 7:**
```javascript
tinymce.init({
    selector: "textarea",
    plugins: "duden",
    toolbar: 'duden_check'
});
```
Using the 'duden_check' icon in the toolbar, the user can toggle the spellcheck of Duden on and off. If you don't want allow users to do this, just ommit it in the toolbar property.

### Plugin Options

You can set various options via the "duden_settings" object. Here is a short example code for TinyMCE 5 with all available settings with explanaitions in the comment sections. You can easily adapt it to TinyMCE 4 or TinyMCE 3. All the settings work the same in the differen TinyMCE Versions. Also, each setting is optional, so if omitted it uses the default setting:

```javascript
tinymce.init({
    selector: "textarea",
    plugins: "duden",
    toolbar: 'duden_check',
    duden_settings: {
        // Enables AI functionality (requires AI Support in DKS)
        // Default is false
        ai: true,

        // If apiEndpoint is ommited it will default to the PHP Proxy Script,
        // so make sure that you have updated the script with your credentials
        // If you set an API Endpoint directly, please make sure that the DKS
        // is available from your network or provide separate credentials
        apiEndpoint: 'http://127.0.0.1:8080/api',

        // If the API is not publicly available please add the
        // credentials to an API user
        // You can either use a username/password combination or an apiKey
        apiCredentials: {
            username: "duden",
            password: "duden" /*,
            apiKey: "??????????" */
        },

        // While the user is editing a text block, this options uses a 
        // `fastSpellCheck` to provide quicker spellchecking feedback.
        autoFastSpellCheck: true,

        // Which property sets should the DKS use
        propertySets: ["base"],

        // Which dictionaries sets should the DKS use
        dictionaries: [],

        // Can be used to activate debug output to browser console.
        debug: false,

        // If a user manually adds hyphenation, DKCE will auto detect it and
        // replaces the '-' char with a soft hyphen
        detectManualHyphenation: true,

        // Which language should the DKCE UI use
        // Defaults to the browser language of the user
        language: "de",

        // The plugin can store check responses from the DKS in the local storage 
        // of the browser. This settings can be used to enable/disable it and 
        // set the cache size and time to live (in seconds).
        localStorageCache: {
            enabled: true,
            maxItems: 100,
            ttl: 3600
        },

        // Which fallback Language should the DKCE Plugin use, if the
        // main language cannot be found. This is especially important when
        // you ommit the language setting, and the language is detected
        // automatically by the users browser settings.
        fallbackLanguage: "de",

        // Should the plugin be activated. If set to false, you can activate
        // it at a later point
        activated: true,

        // Optional: Defines when the Spellchecking Pop Up appears,
        // following options are possible:
        //      'mouseOver'  - Automatically opens pop up when you hover an error highlight (Default)
        //      'leftClick'  - Opens pop up when you left click on an error highlight
        //      'rightClick' - Opens pop up when you right click on an error highlight
        openContextMenuOn: 'mouseOver',

        // Can be used to disable the Duden-Status-Panel at the top of the screen
        // (which indicates network communication)
        // Defaults to: false
        hideStatusPanel: false,

        // You can set the options how the DKS should behave, but keep in mind
        // that the DKS Server may overwrite these settings
        // Please check the DKS Readme if you want to learn more about them.
        hyphenation: true,
        hyphenationStandard: "combined",
        hyphenationInStem: true,
        hyphenationUnaest: false,

        // When set it will ignore spellchecks for all child elements who has
        // the given attribute in the HTML set (can be string or array of strings)
        ignoreAttributes: [],

        // When set it will separate spellchecks for all child elements who has
        // the given attribute in the HTML set (can be string or array of
        // strings). This can be useful for footnotes in HTML code, for example.
        layerAttributes: [],

        // Use single word mode for layers defined in layer Attributes (except when it detects
        // end of sentence characters. Default is true.)
        useSingleWordModeOnLayers: true,

        // Every HTML element that contains at least one of the attributes defined
        // here will be checked by the spell checker in Single Word Mode
        // (useful, e.g., for headings or lists)
        singleWordModeAttributes: ['duden-use-single-word-mode'],

        // Every HTML element that contains at least one of the classes defined
        // here will be checked by the spell checker in Single Word Mode
        // (useful, e.g., for headings or lists)
        singleWordModeClasses: ['duden-use-single-word-mode'],

        // When set it will ignore spellchecks for all child elements who has
        // the given css class in the HTML set (can be string or array of strings)
        ignoreClasses: [],

        // Array of objects that define specific error codes to ignore based on CSS selectors.
        // Each object contains 'code' (error code number) and 'selector' (CSS selector string).
        // The logic is applied recursively for all child elements of selector nodes.
        // Example: [{ code: 111, selector: '.no-lowercase-check' }, { code: 166, selector: '.no-sentence-end-check' }]
        ignoreErrorCodes: [],

        // Every single character of this string will be ignored during the
        // correction check. This can be useful, for example, if the editor
        // inserts characters for marking that are to be ignored by the spell checker.
        ignoreCharacters: "",

        // When set it will ignore spellchecks for paragraphs that have a
        // language attribute attached that are not defined here. If ommited all languages will be checked.
        checkLanguages: [],

        correctionProposals: true,
        singleWordMode: false,
        styleForeign: false,
        styleOld: false,
        styleRegional: false,
        styleColloquial: false,
        styleFiller: false,
        markupMode: "text",
        messageLanguage: "de-DE",
        textLanguage: "de-DE",
        messageLevel: 3,
        spellcheckingLevel: 1,
        orthographyStandard: "duden",

        // Sets the dictonary where proposals will be submitted to. (Default is 'Proposals')
        proposalDictionary: "Proposals",

        // Use markup mode instead of overlay mode (which is the default)
        overlayMode: false,
    
        // Maximum number of concurrent spellchecking requests allowed.
        // If set to 0, no limit will be enforced.
        maxConcurrentRequests: 0,

        // Delay (in milliseconds) before retrying when the maximum number
        // of concurrent requests has been reached. This helps prevent
        // overload and ensures time is freed for other pending requests.
        delayBetweenRequestsInMs: 0,

        // If set to true (and instance is in MarkUp Mode) all markup code is
        // removed from selections (and readded when selection is removed)
        removeMarkupForSelection: false,

        // colors can be used to define the appearance of the highlights. Please keep in mind
        // that in markup mode, the colors may be overwritten by included css Files
        colors: {
            spellingError: '#faa6ae',
            gramarError: '#abe89e',
            rejectedWord: '#abe89e',
            styleError: '#ffd7a8',
            glossaryInfo: '#ffff00'
        },

        // Array of CSS Files to use for DKCE. Please keep in mind that most
        // of the css classes only make sense in markup mode
        cssFiles: ['assets/css/dkce.css'],

        // Path to the dkce javascript source files. Is important so the
        // plugin finds the assets like images and localization files.
        path: "dkce",

        // If set to true, the duden will observe the HTML Elements and inject the Spellchecker automatically
        // on dynamically created or changed HTML nodes
        setUpWatcher: false,

        // If a canvas exceeds this size (in pixels) in overlay mode,
        // it is split into several individual ones
        maxCanvasWidth: 512,
        maxCanvasHeight: 512,

        // Makes the overlay canvas elements visible (for debugging purposes)
        debugCanvas: false,

        // The zIndex where the highlights should be rendered. In general this should be higher than the editor element
        // but lower than pop ups / toolbars etc, that are laying in front of the editor.
        zIndex: 20
    }
});
```

### AI Functionality

** This only works in TinyMCE 5, TinyMCE 6 and TinyMCE 7 **

To enable the ai features of the DKS you need to set the `duden_settings.ai` property to true and add `duden_ai` to the toolbar. Here is an example:

```javascript
tinymce.init({
    selector: "textarea",
    plugins: "duden",
    toolbar: 'duden_check duden_ai',
    duden_settings: {
        ai: true,
        /// add other settings here
    }
});
```

#### Programmatic Control

You can disable or re-enable the spellcheck button programmatically using the following code (When disabled that means, that the spellcheck cannot be reactivated by the user):

```js
    const editor = tinymce.activeEditor || tinymce.editors[0];
    const dudenPlugin = editor.dkce;
    dudenPlugin.enable(false);

    // re-activate it
    dudenPlugin.enable(true);
```

You can also access the API. Here is an example:
```js
    const editor = tinymce.activeEditor || tinymce.editors[0];
    const dudenPlugin = editor.dkce;
    const api = dudenPlugin.api;

    // Update Settings (Your settings will be merged into the active settings)
    api.updateSettings({ spellcheckingLevel: 3 });

    // print out current settings
    console.log(api.getCurrentSettings());

    // Makes a request to the DKS to retrieve all property sets
    api.getPropsets(onSuccess(result) {
        console.log("Property Sets of DKS: ", result);
    });

    // Reinitialize Duden Plugin: This will update the spellchecker elements,
    // which means it will be removed from elements that are no longer editable
    // and added to elements that have become editable
    api.reinitialize()

    // Propose a word to the DKS
    api.proposeWord("Foo);

    // Show a message through the Toast Message System of the Duden Plugin
    api.toast("Hello World!");
    api.toastWarn("A warning!");

    // returns an array with possible AI Actions
    const actions = api.getAIActions();

    // Small Example: This sends an AI Request to the DKS with
    // current selection and opens the AI Assistant Dialog
    const selection = window.getSelection();
    if (selection.rangeCount > 0) {
        const range = selection.getRangeAt(0);
        api.executeAIActionOnRange('actionId', range);
    }

    // Hides the spellchecker context window (if it's visible)
    api.hideContextMenu();
```

### Special Attributes and Classes

If a DOM Element (or a parent Element) in which the spellchecker is injected contains either the class or the attribute *duden-use-single-word-mode*, the single word mode is enforced for the spellchecking. This might be useful for Elements that expect a single word or a headline as example. This works in inline or in iFrame-Mode without further configuration.

```html
    <textarea id="#my-tinymce-element" duden-use-single-word-mode>
    </textarea>

    <textarea id="#my-tinymce-element2" class="duden-use-single-word-mode">
    </textarea>
```

#### Using a configuration file

Optionally, you can use a configuration file to specify options instead of (or in addition to) the options provided in the call to `tinymce.init()`. To use this mechanism, create a file named 'duden-config.json' in the "duden" directory and provide the the desired options and their values in JSON notation.

For example:
```json
{
  "propertySets": ["set1","set2"],
  "textLanguage": "de-CH"
}
```
The plugin ships without a configuration file to avoid overwriting of user defined settings when updating the plugin. The presence of a configuration file is not required for the proper operation of the plugin, and corresponding "404 File not found" errors can be safely ignored.

### Upgrading from previous versions
If you have created a configuration file, please make a backup copy of this file before upgrading, e. g. by copying it to a temporary directory.

If you are upgrading from a previous version, please make sure that you completely delete the "duden" folder within your TinyMCE installation and do not forget to edit the proxy scripts again. Do not keep your old scripts as there might be internal changes that would lead to incompatibilities. With older versions of our TinyMCE plugin, you may have used different settings to initialise the TinyMCE Duden plugin. These are still working, but if possible, use the new "duden_settings" object, as older settings may become obsolete in the future.

Please check especially the correct path in the Proxy Script (if you use one). In foreign versions the path need to include the '/api' slug in the host configuration setting, while in newer version this have to be ommited.

If you are using an additional configuration file, please copy file back to the  'duden' directory and verify that the content of this file is compatible with the options suppported by the current version of the plugin.

## License

(C) Copyright 2022, 2023 by EPC Consulting und Software GmbH.
