var dudenDialog = {
    preInit: function () {
        // Set HTML title
        var title = tinyMCEPopup.getWindowArg('title');
        document.title = title;
        tinyMCEPopup.requireLangPack('duden');
    },
    init: function (editor) {
        // Set header title
        document.getElementById('dialog_title').innerHTML = document.title;
        document.getElementById('insert').value = tinyMCEPopup.getLang('dialog.save');
        document.getElementById('cancel').value = tinyMCEPopup.getLang('dialog.cancel');

        // Create form elements
        var inputDefinitions = tinyMCEPopup.getWindowArg('body');
        var container = document.getElementById('input_container');
        tinymce.each(inputDefinitions, function (inputDefinition) {
            var tableRow = tinymce.DOM.create('tr');
            container.appendChild(tableRow);
            var hasLabel = false;
            if (inputDefinition.label){
                hasLabel = true;
                var labelColumn = tinymce.DOM.create('td', {class: 'no-wrap'});
                tableRow.appendChild(labelColumn);
                var label = tinymce.DOM.create('label', {for: 'duden-' + inputDefinition.name}, inputDefinition.label);
                labelColumn.appendChild(label);
            }
            var inputColumn = tinymce.DOM.create('td');
            tableRow.appendChild(inputColumn);
            if (!hasLabel)
                inputColumn.setAttribute('colspan', 2);
            if (inputDefinition.type === 'listbox') {
                var input = tinymce.DOM.create('select', {
                    name: inputDefinition.name,
                    id: 'duden-' + inputDefinition.name,
                    style: "width: 100%"
                });
                inputColumn.appendChild(input);
                tinymce.each(inputDefinition.values, function (optionDefinition) {
                    var option = tinymce.DOM.create('option', {value: optionDefinition.value}, optionDefinition.text);
                    input.appendChild(option);
                    if (optionDefinition.value === inputDefinition.value)
                        option.setAttribute('selected', '');
                });
            } else if (inputDefinition.type === 'textbox') {
                var input = tinymce.DOM.create('input', {
                    name: inputDefinition.name,
                    id: 'duden-' + inputDefinition.name,
                    style: "width: 100%",
                    value: inputDefinition.value || ''
                });
                inputColumn.appendChild(input);
                tinymce.each(inputDefinition.values, function (optionDefinition) {
                    var option = tinymce.DOM.create('option', {value: optionDefinition.value}, optionDefinition.text);
                    input.appendChild(option);
                    if (optionDefinition.value === inputDefinition.value)
                        option.setAttribute('selected', '');
                });
            }
        });
    },

    save: function () {
        var inputDefinitions = tinyMCEPopup.getWindowArg('body');
        var form = document.getElementById('settings_form');
        var formData = {};
        var value;
        tinymce.each(inputDefinitions, function (inputDefinition) {
            if (inputDefinition.type === 'listbox') {
                var possibleValues = [];
                tinymce.each(inputDefinition.values, function (possibleValue) {
                    possibleValues.push(possibleValue.value);
                });
                value = getSelectValue(form, inputDefinition.name);
                if (possibleValues.indexOf(value) === -1) { // Value not in possible values, possibly integer
                    var parsedValue = parseInt(value);
                    if (possibleValues.indexOf(parsedValue) !== -1)
                        value = parsedValue;
                }
            } else if (inputDefinition.type === 'textbox') {
                value = document.getElementById('settings_form').elements[inputDefinition.name].value;
            } else { // Other input types not yet implemented
                console.error('Invalid input type: ' + inputDefinition.type)
            }
            formData[inputDefinition.name] = value;
        });
        var callback = tinyMCEPopup.getWindowArg('onsubmit');
        callback({data: formData});
        tinyMCEPopup.close();
    }
};
dudenDialog.preInit();
tinyMCEPopup.onInit.add(dudenDialog.init, dudenDialog);