window.addEventListener(`load`, () => {
    const modules = ['./utils.js', './settings.js'];
    let autoscan = true;

    // Insert DKCE CSS (mainly for loading status indicator)
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.href = chrome.runtime.getURL('assets/css/dkce.css');
    document.head.appendChild(link);

    chrome.runtime.onMessage.addListener((msg, sender, response) => {
        if (chrome.runtime.lastError) {
            response();
            return true;
        }

        if ( msg.subject == 'autoscan' ) {
            autoscan = msg.activate
        } else {
            window.postMessage(msg, location.href);
        }

        response();
        return true;
    });

    Promise.all(modules.map(path => import(path)))
        .then((modules) => {
            modules.forEach(module => {
                Object.entries(module).forEach(([key, value]) => {
                    globalThis[key] = value;
                })
            });
            main();
        }).catch(error => console.error("Error while loading modules: ", error));

    const main = () => {
        const getChildDocuments = (rootDocument) => {
            if (!rootDocument) {
                return [];
            }
            let iframes = Array.prototype.slice.call(rootDocument.getElementsByTagName("iframe"), 0);
            let documents = [];
            for (let i = 0; i < iframes.length; i++) {
                if (iframes[i].contentDocument) {
                    documents.push(iframes[i].contentDocument);
                    documents = documents.concat(getChildDocuments(iframes[i].contentDocument));
                }
            }
            return documents;
        };

        const getAllDocuments = (() => {
            return getChildDocuments(document).concat(document);
        });

        const forceSettings = (settings) => {
            settings.language = navigator.language.substring(0, 2);
            settings.overlayMode = true;
            settings.hideStatusPanel = true;
        }

        const readyStateCheckInterval = setInterval(() => {
            if (document.readyState === "complete") {
                Settings.load((settings) => {
                    Settings.resolveActivationMap(settings, document.location.href);
                    forceSettings(settings);

                    const injectedElements = [];

                    const injectSpellcheckers = () => {
                        if (!autoscan) return;
                        if (!settings.activated) {
                            Settings.load((s) => {
                                settings = s;
                                forceSettings(settings);
                                Settings.resolveActivationMap(settings, document.location.href);
                            });
                            return;
                        }

                        const documents = getAllDocuments();
                        for (let i = 0; i < documents.length; ++i) {
                            //const elementsToInjectDKCE = documents[i].querySelectorAll("[contenteditable='true'], textarea");
                            const elementsToInjectDKCE = documents[i].querySelectorAll("[contenteditable='true']");

                            for (let j = 0; j < elementsToInjectDKCE.length; ++j) {
                                if (elementsToInjectDKCE[j].classList.contains("dkce-element")) {
                                    continue;
                                }

                                if (document.body.id === "statamic") {
                                    if (elementsToInjectDKCE[j].classList.contains("bard-source")) continue;
                                    if (elementsToInjectDKCE[j].classList.contains("search")) continue;
                                    if (elementsToInjectDKCE[j].classList.contains("new-item")) continue;
                                    if (elementsToInjectDKCE[j].parentNode && elementsToInjectDKCE[j].parentNode.parentNode && elementsToInjectDKCE[j].parentNode.parentNode.classList.contains("CodeMirror")) continue;
                                }

                                if (!injectedElements.includes(elementsToInjectDKCE[j])) {
                                    injectedElements.push(elementsToInjectDKCE[j]);
                                    DKCE.init(elementsToInjectDKCE[j], settings);
                                }
                            }
                        }
                    }

                    injectSpellcheckers();
                    window.setInterval(injectSpellcheckers, 2000);
                });
                clearInterval(readyStateCheckInterval);
            }
        }, 10);
    };
});
