export const Settings = {
    dynamicServerListURL: 'https://services.epc.de/dks/custom-location.php',
    dksServerList: [
        'https://dks',
        'http://dks'
    ],
    dictionaries: {},
    state: {
        activated: {},
        apiEndpoint: 'https://dks/api',
        apiCredentials: null,
        hyphenation: null,
        hyphenationStandard: null,
        hyphenationInStem: null,
        hyphenationUnaest: null,
        correctionProposals: true,
        singleWordMode: false,
        styleForeign: null,
        styleOld: null,
        styleRegional: null,
        styleColloquial: null,
        styleFiller: null,
        markupMode: 'text',
        messageLanguage: null,
        textLanguage: null,
        messageLevel: 1,
        spellcheckingLevel: 3,
        orthographyStandard: null,
        propertySets: 'base',
        singleWordModeAttributes: ['duden-use-single-word-mode'],
        singleWordModeClasses: ['duden-use-single-word-mode'],
        isChromeExtension: true,
        dictionaries: [],
        debug: false,
        debugCanvas: false,
        configFile: null,
        cssFiles: [],
        openContextMenuOn: "mouseOver"
    },
    save: (settings, onSaved) => {
        chrome.storage.local.set(settings, () => {
            for (let key in settings) {
                Settings.state[key] = settings[key];
            }
            if (onSaved) {
                onSaved();
            }
        });
    },
    load: (onLoaded) => {
        chrome.storage.local.get(Settings.state, (settings) => {
            Settings.state = settings;
            if (onLoaded) {
                onLoaded(Settings.state);
            }
        });
    },
    resolveActivationMap: (settings, href) => {
        settings.activated = settings.activated[parseURL(href).hostname] || false;
    }
};
