# Changelog

Alle nennenswerten Änderungen an diesem Projekt werden in dieser Datei dokumentiert.

Das Format basiert auf [Keep a Changelog](https://keepachangelog.com/de/1.0.0/),
und dieses Projekt hält sich an die [Semantische Versionierung](https://semver.org/spec/v2.0.0.html).

## [2.1.32] - 2025-10-14

### Changed
- Grammatik-Fehler werden von `fastspellchecks` nicht überschrieben, d.h. Sie bleiben weiterhin sichtbar.
- Wenn einige Zeit keine Benutzereingabe erfolgt, während der Fokus in einem Absatz ist, wird ein vollständiger Spellcheck gemacht. 

### Fixed
- Die Highlights werden nun auch während des Tastendrückens aktualisiert und bleiben dabei korrekt mit dem Text synchronisiert.

## [2.1.31] - 2025-10-08

### Fixed
- `fastspellcheck` wurde manchmal nicht benutzt, wenn man in der Mitte eines Absatzen getippt hat.
- Beim Tippen wurden manchmal die nachfolgenden Highlights nicht schnell genug re-positioniert.

## [2.1.30] - 2025-10-07

### Added
- Es ist nun per Konfiguration möglich, die Anzahl gleichzeitiger Requests für die Rechtschreibprüfung mit dem Parameter `maxConcurrentRequests` zu begrenzen.
- Mit dem Parameter `delayBetweenRequestsInMs` kann eine Wartezeit in Millisekunden zwischen erneuten Versuchen (Retries) festgelegt werden, um anderen Requests genügend Ressourcen zur Verfügung zu stellen.
- Für interaktive Requests wird der `spellcheckingLevel` nun automatisch auf `1` gesetzt, um die CPU Usage des DKS zu entlasten.

### Fixed
- Wenn sich neue Requests, aufgrund von Benutzerinteraktion, mit den initialen DKS-Anfragen überlappen, wurde nicht auf "singleWordMode" für die interaktiven Requests gewechselt.

## [2.1.29] - 2025-09-26

### Added
- Woodwing: `publicationSettings` greifen nun auch für den Print Editor.

### Changed
- HTTP Status Code 429 wird nun gesondert verarbeitet

### Fixed
- Manchmal wurden Highlights am Ende teilweise abgeschnitten (z.B. in der TinyMCE Integration für InterRED)
- Wenn man ein Wort vorgeschlagen wurden, verschwanden/flackerten die Highlights - bis die Server-Antwort erhalten wurde.
- ToastMessages: Identische Toast-Nachrichten ausfiltern, damit diese nicht mehrfach angezeigt werden. 

## [2.1.28] - 2025-09-17

### Fixed
- Woodwing Readme: Fehlerhafte Spracheinstellung in Readme-Datei korrigiert.
- Woodwing: Die Metadaten des Artikels werden nun asynchron abgerufen (Es konnte vorher dazu führen, dass manchmal Filtereinstellungen nicht richtig gegriffen haben).
- Range Check für Charmap gefixt (Führte manchmal zu Fehlerausgaben auf der Konsole).
- Woodwing: `availablePropertySets` können nun in den `publication`-Settings überschrieben werden.

## [2.1.27] - 2025-09-04

### Fixed
- "Leere" Requests werden nicht an den Duden Korrekturserver geshickt. Zuvor wurden "zero width"-Leerzeichen nicht als Leerzeichenkette erkannt und lösten fälschlicherweise einen Request aus.
- Bei Verwendung des Mutation Observers (setUpWatcher: true) wurden bisher mehrere identische Requests an den Duden-Korrekturserver gesendet. Dies wurde behoben: Läuft bereits eine Anfrage, werden keine zusätzlichen Requests mehr gestartet.

## [2.1.26] - 2025-08-18

## Changed
- Woddwing Plugin: PHP SOAP API wird genuzt um WCML Daten abzurufen anstatt Javascript API (da dies mit neueren Studio Servern aufgrund nicht abrufbarer Ticket ID nicht kompatibel war).

### Fixed
- Woodwing Plugin: Die Meldung "Rechtschreibprüfung aktiviert" wird bei Start angezeigt, obwohl das Plugin noch inaktiv ist.
- Woodwing Plugin: Publikations-Information wurden nicht abgerufen, wenn keine Publication-Einstellungen getroffen wurden.
- Woodwing Digitaleditor: Kein Refresh der Highlights bei Formatierungsänderung 
- Woodwing Digitaleditor: Einfügen eines Kommentars stört Keyboardnavigation
- Woodwing: "activateForLanguage"-Einstellung kann nun optional auch im BCP 47 Standard angegeben werden ("de-DE", statt "deDE") 

## [2.1.25] - 2025-07-13

### Added
- Wenn es überschneidungen zwischen Glossar- und Style-Auszeichnungen gibt, hat das Glossar-Highlight nun die größere Priorität (DKS 1.10.3+ benötigt für korrekte Priorisierung).

### Fixed
- Woodwing Plugin: Duden Eigenschaften aus InDesign-Absatzformaten waren ohne Auswirkungen wegen eines Encoding-Fehlers.
- Woodwing Plugin: Als Standard-Modus für das Plugin wird nun der Overlay-Modus genutzt.
- Dieses Changelog ist nun in den verschiedenen Distributions-Paketen enthalten.
- Overlay-Modus: Die Rechtschreibprüfung wurde, aufgrund eines Fehlers, generell bei jedem Tastananschlag gestartet. Nun wird die Prüfung nur bei bestimmten Events und bei Wortgrenzen ausgelöst. 

## [2.1.24] - 2025-06-17

### Added
- Neue Einstellung `ignoreErrorCodes`: Ermöglicht das Ignorieren spezifischer Fehlercodes basierend auf CSS-Selektoren. Die Logik wird rekursiv auf alle Kindelemente der ausgewählten Nodes angewendet.
- Woodwing Plugin: Automatische Erkennung von Duden-spezifischen Eigenschaften aus InDesign-Absatzformaten

### Fixed
- Plugin war mit dem Digital-Editor von Woodwing Studio >= 11.27 inkompatibel (veraltete API Funktion wurde vom Duden Plugin genutzt)
- Fehlende Dokumentation zu `setUpWatcher` Einstellungen hinzugefügt

## [2.1.23] - 2025-06-15

### Fixed
- Wenn der `setUpWatcher` aktiviert wird, werden nun auch die root-Elemente berücksichtigt.
- Spellchekcer-Instanzen, die nachträglich / dynamisch initialisiert werden, erhalten nun auch `activate`-Events von der API
- Bessere Fehlerbehandlung des Config-File-Loader

## [2.1.22] - 2025-05-22

### Added
- Woodwing Plugin: Mit der Einstellung `activateForLanguages` kann nun eingestellt werden, in welchen Sprachen das Duden Plugin aktiviert werden soll oder nicht (siehe dazu die README Datei).
- Woodwing Plugin: Es können nun Einstellungen für das Plugin in der Content Station Konfiguration gesetzt werden. So kann man z.B. unterschiedliche Einstellungen für den Digital- und Print-Editor setzen (siehe dazu die README Datei).
- Woodwing Plugin: Es können nun spezifische Einstellungen für Publikationen zugewiesen werden (siehe dazu die README Datei).

## [2.1.21] - 2025-05-16

### Fixed
- Wenn der Server für die Plain-Text-Sprachdateien fälschlicherweise mit dem Document-Typ `text/xml` oder `application/xml` antwortet, kann der Inhalt im ´Firefox´-Browser nicht geparsed werden und es führt zu einem Fehler. Der ´content-type´ wird nun vom Client überschrieben, was den Fehler beseitigt.

## [2.1.20] - 2025-05-15

### Fixed
- Tiny MCE 5: Das Duden Plugin konnte nicht korrekt initialisiert werden, da auf eine API von Tiny MCE 6 zugegriffen wurde.
- Es führte zu einem Fehler, wenn der DKS bei einem `check`-Request mit einem leeren Array geantwortet hatte (z.B. wenn die Lizenz ungültig wurde).

## [2.1.19] - 2025-03-28

### Fixed
- Wenn eine HTML-Seite mehrfach verschachtelte IFrames (u.A. mit ShadowRoot-Elementen) enthielt, wurde die Position des Kontextmenü's falsch berechnet.

## [2.1.18] - 2025-03-25

### Fixed
- Im CK-Editor gabe es im Korrektur-Popup einen kleinen Layoutfehler bei dem `Ignorieren`-Button.

## [2.1.17] - 2025-03-25

### Changed
- Chrome Extension: Migration auf Google Chrome Extension Manifest V3 API

## [2.1.16] - 2025-03-24

### Fixed
- Woodwing Plugin: Wenn die Sprache über die SDK Funktion keinen Wert zurückliefert, konnte das Plugin nicht gestartet werden.

- DKS Propsets: `hyphstd` Property hatte einen falschen Datentyp (`boolean`) zugewiesen, es sollte aber ein `string` ein. Das führte dazu, dass die Propertysets bei bestimmten Korrekturprofilen nicht korrekt geladen werden konnten.

- Die Fallback-Sprache in den Einstellungen wurde manchmal nicht korrekt geladen. Grund: Wenn eine INI Datei nicht geladen werden konnte, und die Server Response hatte ein 404 Status-Code, aber der Body war nicht leer, wurde die Fehlerbehandlung nicht korrekt getriggered.

## [2.1.15] - 2025-03-17

### Added
- TinyMCE 5, 6 und 7: AI-Funktionalität hinzugefügt. Kann mit der Eigenschaft `ai` in den Einstellungen aktiviert/deaktiviert werden. Benötigt einen DKS mit AI Support. Außerdem muss `duden_ai` in die Toolbar Einstellungen von TinyMCE hinzugefügt werden.
- DKCE Api:
    - `getAIActions`: Liefert eine Liste von möglichen KI Aktionen zurück.
    - `executeAIActionOnRange(id, selection)`: Sendet eine KI Anfrage and den DKS und öffnet den KI-Assistenten.
    - hideContextMenu(): Schließt das Korrektur-Fenster (wenn es aktuell sichtbar ist).

### Fixed
- In Texten, die UTF-16 Surrogate Pairs enthalten, wurde die Position der nachfolgenden Highlights falsch berechnet.

## [2.1.14] - 2025-03-03

### Added
- Woodwing: Unterstützung für Auswahl von Korrekturprofilen hinzugefügt (Bitte README des Woodwing Plugins beachten).
- DKCE Api:
    - getProposals hinzugefügt, um Korrekturprofile vom DKS abzurufen
    - toastWarn hinzugefügt, um eine Warnung über das Toast-Nachrichtensystem auzszugeben

### Fixed
- Duden Status Icon wurde nicht aktualisiert, wenn das Plugin per API ein- oder ausgeschaltet wurde oder explizit die Darstellung verwendet wurde.

## [2.1.13] - 2025-02-17

### Fixed
- Plugin wirft manchmal eine Exception (bei mehreren Editor Instanzen), wenn eine Cursor-Selektion nicht gefunden werden kann (Null-Saftey-Check wurde hinzugefügt)

## [2.1.12] - 2025-02-06

### Added
- TinyMCE 7 Support hinzugefügt.
- Chrome Extension: Support für Authentifizierung per API-Key hinzugefügt.
- Chrome Extension: Einstellung hinzugefügt, wie Context Menu geöffnet werden soll.
- Chrome-Extension: Autoscan optimiert

### Fixed
- Das Re-Triggern von Layout Changes in Chrome konnte zu einer Endlos-Schleife (und einer Exception) führen.

## [2.1.11] - 2025-01-30

### Fixed
- Das Re-Triggern von Layout Changes in Chrome konnte zu einer Endlos-Schleife (und einer Exception) führen.

## [2.1.10] - 2025-01-29

### Fixed
- Chrome Extension: Fehler im Support für CK Editor beseitigt (es wurde u.U. Javascript Source Code in Texteingabefelder eingefügt).
- Chrome Extension: Bei der Authentifizierung wurde fälschlicherweise ein nativer Browser-Auth-Dialog geöffnet, wenn der Server mit einem `Www-Authenticate`-Header geantwortet hat.
- Chrome Extension: Fix in Default-Einstellungen, sodass keine unnötigen Requests abgeschickt werden
- Chrome Extension: Die Versionsnummer wurde nicht korrekt angezeigt

## [2.1.9] - 2025-01-21

### Fixed
- TinyMCE 6: Wenn man über die TinyMCE API `setEditableRoot(false)` benutzt, während bereits ein Request scheduled worden ist bzw. aktuell noch in Bearbeitung ist, gibt es eine Race Condition, die zu einer Exception führt.

## [2.1.8] - 2025-01-08

### Fixed
- TinyMCE 6: Die TinyMCE-Einstellung `editable_root` und die Methode `setEditableRoot` werden jetzt unterstützt. Die Rechtschreibprüfung wird automatisch deaktiviert, wenn ein Bereich nur lesbar ist, und wieder aktiviert, wenn der Bereich editierbar wird.

### Added
- Neue API-Methode `reinitialize`: Diese Methode initialisiert Bereiche ohne Rechtschreibprüfung und entfernt die Rechtschreibprüfung aus Bereichen, die aktuell nicht editierbar sind, aber eine aktive Rechtschreibprüfung haben.

## [2.1.7] - 2024-12-11

### Fixed

- Bei aktivierter Rechtschreibprüfung erschienen manchmal Scrollbalken in Editoren.

## [2.1.6] - 2024-11-20

### Added

- Es gibt zwei neue Einstellungen: "singleWordModeAttributes" und "singleWordModeClasses". Beide Einstellungen erwarten ein Array aus Strings. Attribute bzw. Klassen die in diesen Eigenschaften definiert sind, werden im "Single Word Mode" geprüft. Dies ist nützlich für Eingabefelder, die z.B. nur ein Wort oder eine Überschrift enthalten.

- In dem Wordpress Theme "Twenty Twenty-Four" in Wordpress 6.6.1 war das Highlight-Canvas verschoben. Dies lag daran, da das CSS dynamisch von Wordpress verändert wurde - nun sollte die Position bei einem re-rendering neu gesynced werden wenn notwendig.

## [2.1.5] - 2024-07-25

### Fixed

- Während ein Satz in einem aktiven Editor unvollständig ist, wird das letzte Wort nicht geprüft (um zu verhindern, dass das unvollständige Wort mit einem Fehler markiert wird). Die Erkennung, ob das letzte Wort unvollständig ist, hatte einen Fehler. Nun werden Unicode Properties benutzt, um eine verlässliche Erkennung zu gewährleisten.

- Wenn man mehrere Instanzen auf einer Seite nutzte, wurde die Rechtschreibprüfung unterbrochen/abgebrochen, wenn man schnell zwischen den verschiedenen Instanzen wechselte.

### Added

- Wenn das HTML-Element (oder ein Eltern-Element) die Klasse oder das Attribut "duden-use-single-word-mode" enthält, wird die Rechtschreibprüfung nur in dem Einzelwortmodus erfolgen. Dies ist nützlich für Eingabefelder, die z.B. nur ein Wort oder eine Überschrift enthalten.

## [2.1.4] - 2024-07-21

### Fixed

- In Wordpress 6.6 wurde das Duden-Icon nicht korrekt im Header platziert

## [2.1.3] - 2024-07-17

### Added

- Es gibt nun die optionale Einstellung "zIndex", um expliziet den zIndex-Layer zu spezifizieren, wo die Highlights des Overlay-Modus gerendert werdern. Der Default-Wert ist 20. In der Regel sollte er höher liegen, als das Editor-Element und niedriger als Toolbars oder Pop-Elemente, die über dem Editor liegen.

### Fixed

- Probleme mit Overlay-Modus in Kombination mit CSS Grid Layouts behoben.


## [2.1.2] - 2024-06-25

### Added

- Wenn Konfigurations-Dateien abgerufen werden, werden diese gecached, so dass diese nicht mehrfach über das Netzwerk abgerufen werden müssen.

- TinyMCE: Es kann nun programmatisch der Duden-Toggle-Button aktiviert / deaktiviert werden. Außerdem wurde die TinyMCE-Readme mit Beispielen aktualisiert, wie man auf das Duden-TinyMCE-Plugin zugreifen kann, um z.B. Einstellungen nachträglich zu ändern.

### Changed

- Wenn man "ignoreCharacters" definiert hat, werden die definierten Zeichen auch im Context Menu und beim Vorschlag in ein Wörterbuch berücksichtigt und entfernt.

- Wordpress: Die Plugin Einstellungs-Seite wurde überarbeitet und enthält nun mehr Konfigurationsmöglichkeiten. Im Reiter "Erweitert" befindet sich auch ein Text-Feld das (optionale) JSON Konfigurationen erlaubt. So kann man alle Features der Duden-Korrektur nutzen, auch wenn dafür kein gesondertes Einstellungsfeld vorhanden ist.

### Fixed

- Wordpress: Der Duden-Button erscheinte u.U. nicht, wenn man die Header Toolbar customized hatten.

- Wordpress: Es wird nun verhindert, dass das Plugin mehrfach instanziiert wird.

- Wenn sich die Position eines Elements verändert haben, wurde u.U. die Highlights und die Position des Kontextmenü's nicht aktualisiert. Wenn man beispielsweise im Gutenberg-Editor von Wordpress, die Seitenbar auf- oder zugeklappt hat, wurden die Mauszonnen, die ein Kontextmenü öffnen, nicht aktualisiert.

## [2.1.1] - 2024-06-12

### Added

### Changed

- Highlight Rendering im Overlaymodus nutzt nun einen Shadow-Root für eine höhere Kompatibilität.

### Fixed

- Wenn eine Seite iFrames enthalten hat, konnte es einige Sekunden dauern, bis das Korrektur-Pop Up an der richtigen Stelle aufklappte.

- Das Rendering des Wordpress Plugin konnte nicht korrekt initialisiert werden.

## [2.1.0] - 2024-06-06

### Added
- Es gibt nun die (optionalen) Parameter 'maxCanvasWidth' und 'maxCanvasHeight'. Wenn im Overlaymodus ein Canvas diese Größe (in Pixel) überschreitet wird es aufgeteilt in mehrere einzelnen. Mehrere kleiner Canvas-Elemente sorgen in der Regel für eine bessere Performance. Mit dem Parameter 'debugCanvas' können die Canvas visualisiert werden (dies ist für Debugging-Zwecke gedacht).

### Changed

- Wenn man die Eigenschaft "debug" auf true setzt erhält man nun eine Vielzahl von Debug-Ausgaben und Informationen in der Browser-Konsole. Dies kann nützlich für die Fehlerdiagnose sein.

- Neuer verbesseter Renderer: Der Renderer des Overlaymodus wurde verbessert. Dadurch steigert sicht Performance und Lags sollten verschwinden/minimiert werden. Der Parameter "renderDelay" wird daher nicht mehr benötigt und wurde entfernt.

### Fixed

- Der Korrekturcheck wurde teilweise zu spät getriggert während man getippt hat.

- Das Context Menu verschwand manchmal, wenn man mit den Cursor-Tasten durch die Korrekturergebnise navigiert hat.

- Wenn sich die DPI/Zoomfaktor ändert, werden die Highlights aktualisiert und neu gezeichnet

- Wenn man ein Wort nicht mit einem Leerzeichen/Satzendzeichen beendet hat, und direkt per Mausklick den Cursor bewegt/entfernt hat, wurde die Rechtschreibprüfung nicht aktualisiert.

- Wenn das Plugin in ein HTML-Editor injeziert worden ist, welches selbst einen Scrollbalken hat und man mit den Pfeiltasten in nicht sichbare Bereiche navigierit hat, wurde das Context Menü an einer falschen Stelle angezeigt. Nun kann man nicht mehr außerhalb des sichtbaren Bereichs eines Editor navigieren (wenn dieser Scrollbalken enthält).

## [2.0.12] - 2024-05-09

### Fixed

- Wordpress Plugin: PHP Proxy Script Warning behoben (Wenn Warnings in PHP >= 8.1 aktiviert waren, konnte das Script nicht korrekt ausgeführt werden)

- Wordpress Plugin: Versionsnummer wird nun korrekt angezeigt

## [2.0.11] - 2024-02-21

### Added

- Es gibt nun den Konfigurations-Parameter 'useSingleWordModeOnLayers'. Damit kann die Einzelwortprüfung für definiere Layers (aus layerAttributes) benutzt werden (solange kein Satzendezeichen gefunden wurde).

### Fixed

- Wenn ein Korrekturvorschlag über Layer-Grenzen hinweg geht, wird im Context-Menu nur der tatsächliche Vorschlag angzeigt. Ggf. wird das Übernehmen von Vorschlägen deaktiviert, um zu verhindern, dass ein Layer überschrieben wird. In dem Fall soll der User die Korrektur manuell vornehmen.

## [2.0.10] - 2024-02-07

### Added

- Es gibt nun den Konfigurations-Parameter 'layerAttributes'. Hier kann ein oder mehrere Attribute definiert werden, die von der Rechtschreibprüfung als seperate Textblöcke betrachtet werden. Dies ist z.B. hilfreich um Fußnoten, die im Quellcode direkt im Fließtext definiert sind separat zu prüfen.

### Fixed

- Die Konfigurationsparameter "ignoreAttributes", "ignoreClasses" und "checkLanguages" wurden teilweise ignoriert, wenn es in tief verschachteltes HTML eingebettet war.

## [2.0.9] - 2024-01-17

### Added

- Woodwing: Es kann nun (getrennt nach Digital- und Print-Editor) konfiguriert werden ob das Duden-Plugin beim Öffnen eines Artikels automatisch aktiviert wird (siehe Readme-Datei).

- Es gibt nun den Konfigurations-Parameter "ignoreCharacters". Hier kann ein String übergeben werden. Jedes einzelne Zeichen dieses Strings wird bei der Korrekturprüfung ignoriert. Dies kann z.B. sinvoll sein, wenn der Editor Zeichen zur Markierung einfügt, die von der Rechtschreibprüfung ignoriert werden sollen.

- Wordpress: Die Einstellungs-Seite enthält nun Informationen über den Status der DKS Server Konfiguration. So wird direkt ersichtlich ob die eingegebenen Daten korrekt sind und eine Verbindung zum DKS Server erfolgreich aufgebaut werden kann oder wo der Benutzer ggf. Daten korrigieren muß.

### Changed

- Wordpress: Duden-Panel wurde aus dem Beitrags-Panel in ein eigenes verschoben (Duden Icon befindet sich in der oberen Leiste).

### Fixed

- Bugfix: Lokalisierung im Wordpress Plugin hat manchmal nicht korrekt funktioniert

- Bugfix: Wenn man Rechtsklick als Methode benutzt, um das Duden-Fester zu öffnen, und gleichzeitig auch ein TinyMCE Context Menü - wird fälschlicherweise das native Context Menu als Fallback verwendet, anstelle des von TinyMCE.

- Bugifx: In der neusten Version vom Wordpress Gutenberg Editor war das Plugin nicht in der Lage die Gutenberg-Blöcke zu erkennen. Nun funktioniert dies auch mit Gutenberg Editor, der in ein iFrame eingebettet ist.

- Bugfix: Wenn man in der Konfiguration des Wordpress-Plugins ein zusätzliches '/'-Zeichen am Ende des Pfades definiert hat, konnte (je nach Server-Konfiguration) das Initialisieren des PlugIns fehlschlagen.

## [2.0.8] - 2023-07-19

### Changed

- Die Standard-Einstellung des Parameters "hyphenation" hat sich von "true" auf "false" geändert.

- Wenn man Rechtsklick als Methode benutzt, um das Duden-Fenster zu öffnen, wird an Stellen, die keine Korrekturvorschläge enthält, das Standard-Browser-Contextmenü geöffnet (was bisher verhindert wurde).

- Einige Debug-Ausgaben entfernt

## [2.0.7] - 2023-07-19

### Changed

- Performance-Optimierung: Bei sich wiederholenden MouseMove Events über Highlights oder Kontextmenü-PopOvers, wird sich deren Position gemerkt, so dass aufwendige Neu-Berechnung vermieden werden.

- Performance-Optimierung: Die Highlight-Positionen werden beim Render gecached, so dass Sie bei anderen Operationen nicht erneut berechnet werden müssen

### Fixed

- Highlights wurden manchmal nicht korrekt entfernt

## [2.0.6] - 2023-06-25

### Added

- Es gibt nun den Konfigurations-Parameter "configFile". Mit ihm ist es möglich, eine separate JSON Datei anzugeben, die benutzt wird um Einstellungen zu überschreiben. Der Default-Wert versucht die Datei "duden-config.json" zu laden. Das führt zu einem HTTP Request, auch wenn die Datei nicht vorhanden ist, deshalb wird empfohlen, den Wert mit NULL oder einem leeren String zu konfigurieren, wenn das Feature nicht genutzt werden soll.

## [2.0.5] - 2023-06-15

### Added

- Es gibt nun den Konfigurations-Parameter "checkLanguages". Wenn hier Sprachen gesetzt werden, werden alle Passagen ignoriert die mit einer fremden Sprache im lang-Attribute gekennzeichnet sind.
- Es gibt nun den Konfigurations-Parameter "ignoreClasses", der exakt wie "ignoreAttributes" funktioniert, allerdings nicht auf HTML Attribute sonder auf CSS Klassen wirkt.
- Der "ignoreAttribute" Konfigurations-Parameter wurde umbeannt in "ignoreAttributes" und kann nun auch mehrere Einträge enthalten (als komma-getrennter String, oder als Array).

## [2.0.4] - 2023-05-11

### Added

- Es gibt nun den neuen Konfigurations-Paramteter "ignoreAttribute". Mit ihm kann man ein HTML Attribute definieren, welches die Auszeichnungen von Elementen verhindert, die ein Elternelement mit dem angegebenen Attribute haben.

### Fixed

- Potentieller "NoSuchMethodError" Bug im Overlay Mode gefixt, wenn das Spellchecker Element, aus dem DOM entfernt wurde.

- Wortgrenzen innerhalb von Tabellen-Zellen wurden manchmal nicht erkannt

## [2.0.3] - 2023-04-13

### Added

- Die Auszeichnungen der Korrekturprüfung können nun definiert werden, mithilfe der 'color'-property (siehe Readme).

- Der Paramter "renderDelay" wurde hinzugefügt. Hier kann eine Zeit in Millisekunden angegeben werden, wo das rendern der Highlights nach einem Scrollevent vorrübergehend ausgesetzt werden kann. Das ist sinvoll für sehr komplexe Editoren, wo das Rendern beim Scrollen oft hinterhergehinkt hat.

- Support für Authentifizierung mit API-Keys hinzugefügt

### Fixed

- Wenn es mehrere Instanzen auf einer Seite gab, konnte es passieren, dass die Maus-Events nicht sauber registriert wurde, was dazu führte, dass das PopOver nicht mehr geschlossen werden konnte, in dem der User mit links in einen anderen Bereichs der Seite geklickt hat.

- Verbesserung der Aktualisierung und Darstellung von der Korrektur-Highlights.

- Duden-Icon State wurde im TinyMCE 6 falsch dargestellt

- Context-Menu wurde an falscher Positon geöffnet, wenn Editoren innerhalb Shadow DOM Nodes benutzt werden (z.B. TinyMCE 6)

### Changed

- Der Overlay-Modus wird nun standardmäßig verwendet. Er kann aber mit dem Parameter "overlayMode" auf "false" gesetzt werden, um weiterhin den MarkUp Modus zu verwenden.

## [2.0.2] - 2023-02-17

### Added

- Die Auszeichnungen der Korrekturprüfung können nun definiert werden, mithilfe der 'color'-property (siehe Readme).

- Der Paramter "renderDelay" wurde hinzugefügt. Hier kann eine Zeit in Millisekunden angegeben werden, wo das rendern der Highlights nach einem Scrollevent vorrübergehend ausgesetzt werden kann. Das ist sinvoll für sehr komplexe Editoren, wo das Rendern beim Scrollen oft hinterhergehinkt hat.

### Fixed

- Im Overlay-Modus wurde bei jedem Key-Event eine Rechtschreibprüfung durchgeführt. Dies geschieht jetzt nur noch bei Wortgrenzen (oder bei speziellen Tasten, wie z.B. die Pfeiltasten).

- Wenn es mehrere Instanzen auf einer Seite gab, konnte es passieren, dass die Maus-Events nicht sauber registriert wurde, was dazu führte, dass das PopOver nicht mehr geschlossen werden konnte, in dem der User mit links in einen anderen Bereichs der Seite geklickt hat.

### Changed

- Der Overlay-Modus wird nun standardmäßig verwendet. Er kann aber mit dem Parameter "overlayMode" auf "false" gesetzt werden, um weiterhin den MarkUp Modus zu verwenden.

## [2.0.2] - 2023-02-17

### Added

- Die Maus-Aktion, welche das Rechtschreibprüf-Fenster öffnet kann nun spezifizeirt werden. Es kann wie bisher durch hovern über ein Fehlerwort automatisch geöffnet werden (was die Standardeinstellung ist), oder per linkem oder rechtem Mausklick.

### Changed

- Das Duden-Icon wird in Graustufen dargestellt wenn die Rechtschreibprüfung deaktiviert ist (nur TinyMCE5 und TinyMCE6).
