/*
 * This script will be injected into all frames and will take care that the CKEDITOR
 * will get informed about changes (for example for auto save component).
 *
 * We had to create a separate content script for the extension because this was
 * the only way to get access to the CKEDITOR instance.
 *
 * A better way would be if we can trigger DOM events that the CKEDITOR will listen to
 * which will lead to the same result, but I was unable to fake the required DOM events
 * (CKEDITOR did ignore them entirely when created programatically). Would need deeper
 * investigation to make it work.
 *
 * The problem with the current appraoch is that we are probably bound to specific versions
 * of CKEDITOR and need to update this script, when things getting changed.
 */
document.addEventListener("DOMContentLoaded", () => {
    if (!document.body) return;

    const script = document.createElement("script");
    script.type = "text/javascript";
    script.src = chrome.runtime.getURL("autosave_ckeditor_script.js");
    document.head.appendChild(script);
});
